jQuery(document).ready(function($) {
    // Sélecteur mis à jour pour les nouvelles versions de Gutenberg
    $('figure.wp-block-gallery, .wp-block-gallery').each(function(index) {
        // Gestion des deux structures possibles (ancien et nouveau format)
        const images = $(this).find('.wp-block-image a, .blocks-gallery-item a, .wp-block-gallery-item a');
        
        images.each(function() {
            // Ajout de l'attribut pour le diaporama
            $(this).attr('data-elementor-lightbox-slideshow', 'elementor-wp-block-gallery-' + index);
            
            // Recherche de la légende dans différentes structures possibles
            let caption = $(this).next('.wp-element-caption').text() || 
                         $(this).closest('figure').find('figcaption').text() ||
                         $(this).closest('.blocks-gallery-item, .wp-block-gallery-item').find('figcaption').text() ||
                         '';
            
            // Ajout du titre si une légende est trouvée
            if (caption) {
                $(this).attr('data-elementor-lightbox-title', caption);
            }
            
            // Configuration complète de la lightbox
            $(this).attr({
                'data-elementor-open-lightbox': 'yes',
                'data-elementor-lightbox-enable-zoom': 'yes',
                'data-elementor-lightbox-enable-share': 'yes',
                'data-elementor-lightbox-enable-fullscreen': 'yes',
                'data-elementor-lightbox-enable-slideshow': 'yes',
                'data-elementor-lightbox-show-arrows': 'yes',
                'data-e-disable-page-transition' : true
            });
            
            // Définir une description si nécessaire
            if ($(this).find('img').attr('alt')) {
                $(this).attr('data-elementor-lightbox-description', $(this).find('img').attr('alt'));
            }
        });
    });

    // Ajout des classes Swiper aux flèches de navigation
    $(document).on('elementor/popup/show', function() {
        setTimeout(function() {
            $('.elementor-lightbox .elementor-swiper-button-prev')
                .addClass('swiper-button-prev')
                .attr('aria-label', 'Previous')
                .attr('tabindex', '0');
            
            $('.elementor-lightbox .elementor-swiper-button-next')
                .addClass('swiper-button-next')
                .attr('aria-label', 'Next')
                .attr('tabindex', '0');
        }, 100);
    });
});