<?php
/**
 * Theme functions and definitions
 *
 * @package HelloEmandarine 
 */

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_EMANDARINE_VERSION', '6.0' );


/*--------------------------------------------------------------
# FICHIER INIT GLOBAL
--------------------------------------------------------------*/

// Inclure le fichier init.php
// include 'init.php';
include 'outilsElementor.php';

function mettre_en_gras_mots_cles($contenu) {
    // Récupérer les mots-clés
    $motsCles = get_option('seo_keyword');

    // Vérifier si des mots-clés sont définis
    if ($motsCles) {
        $motsCles = explode(',', $motsCles);

        // Charger le contenu dans un document DOM
        $dom = new DOMDocument();
        @$dom->loadHTML('<?xml encoding="utf-8" ?>' . $contenu, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);

        // Parcourir tous les nœuds textuels
        $xpath = new DOMXPath($dom);
        foreach ($xpath->query('//text()') as $node) {
            $nodeText = $node->nodeValue;

            // Vérifier si le mot-clé apparaît dans une URL
            $motCleDansURL = false;
            preg_match_all('/https?:\/\/[^\s]+/', $nodeText, $matches);
            foreach ($matches[0] as $url) {
                foreach ($motsCles as $motCle) {
                    if (stripos($url, trim($motCle)) !== false) {
                        $motCleDansURL = true;
                        break 2;
                    }
                }
            }

            if (!$motCleDansURL) {
                // Mettre en gras les occurrences des mots-clés dans le texte
                foreach ($motsCles as $motCle) {
                    $motCle = trim($motCle);
                    $nodeText = preg_replace('/\b' . preg_quote($motCle, '/') . '\b/i', '<strong>$0</strong>', $nodeText);
                }
                $fragment = $dom->createDocumentFragment();
                $fragment->appendXML($nodeText);
                $node->parentNode->replaceChild($fragment, $node);
            }
        }

        // Récupérer le contenu modifié
        $contenu = $dom->saveHTML();
    }

    return $contenu;
}

// Appliquer la fonction sur le contenu principal
// add_filter('the_content', 'mettre_en_gras_mots_cles');

// Appliquer la fonction sur les widgets de texte
// add_filter('widget_text', 'mettre_en_gras_mots_cles');

// Appliquer la fonction sur le texte du pied de page
// add_filter('wp_footer', function($footer_content) {
//     echo mettre_en_gras_mots_cles($footer_content);
// });


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


if ( ! isset( $content_width ) ) {
	$content_width = 1440; // Pixels.
}

/*--------------------------------------------------------------
# SUPPORT POUR LE THEME
--------------------------------------------------------------*/

function mytheme_setup(){
    load_theme_textdomain( 'emandarine', get_template_directory() . '/languages' ); // traduction du thème
    add_theme_support( 'automatic-feed-links' ); //liens RSS dans <head>
    // add_theme_support( 'editor-styles' ); // activation des styles personnalisés pour l'éditeur Gutenberg (back-office)
    // add_editor_style('css/template.css'); // chemin vers la feuille de style pour l'éditeur Gutenberg (back-office)
    add_theme_support( 'menus' ); // Menus
    add_theme_support( 'title-tag' ); // Balise <title> automatique
    add_theme_support( 'post-thumbnails' ); // Image à la une
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'style', 'script', 'navigation-widgets' ) ); // Balises HTML 5 valides
    add_theme_support( 'align-wide' ); // Grande et pleine largeur
    add_theme_support( 'responsive-embeds' ); // Responsive pour les embeds
    add_theme_support( 'custom-line-height' ); // "line-height" pour les blocks paragraphes et titre
    add_theme_support( 'custom-spacing' ); // Padding pour les blocks colonnes, bannière, groupe
    add_theme_support( 'post-formats', array('link','aside', 'gallery','image','quote','status','video','audio','chat') ); // Ajoute des formats à certains types de post
    add_theme_support( 'custom-logo', array(
        'site-title',
        'site-description',
        'height'      => 100,
		'width'       => 350,
		'flex-height' => true,
		'flex-width'  => true,
       ) 
    );

    add_post_type_support( 'page', 'excerpt' );
    /*
    * WooCommerce.
    */

    if ( hello_emandarine_is_woocommerce_activated() ) {
    // WooCommerce in general.
    add_theme_support( 'woocommerce' );
    // Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
    // zoom.
    add_theme_support( 'wc-product-gallery-zoom' );
    // lightbox.
    add_theme_support( 'wc-product-gallery-lightbox' );
    // swipe.
    add_theme_support( 'wc-product-gallery-slider' );

    }

    
}
add_action('after_setup_theme', 'mytheme_setup');


if ( ! function_exists( 'hello_emandarine_is_woocommerce_activated' ) ) {
	/**
	 * Query WooCommerce activation
	 */
	function hello_emandarine_is_woocommerce_activated() {
		return class_exists( 'WooCommerce' ) ? true : false;
	}
}

if ( ! function_exists( 'hello_emandarine_display_header_footer' ) ) {
	/**
	 * Check whether to display header footer.
	 *
	 * @return bool
	 */
	function hello_emandarine_display_header_footer() {
		$hello_emandarine_header_footer = true;

		return apply_filters( 'hello_emandarine_display_header_footer', $hello_emandarine_header_footer );
	}
}

/*
 * fonction qui enregistre des emplacements pour les modèles créés à 
 * l'aide de l'extension Elementor Pro 
 */
if ( ! function_exists( 'hello_emandarine_register_elementor_locations' ) ) {
	/**
	 * Register Elementor Locations.
	 *
	 * @param ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager $elementor_theme_manager theme manager.
	 *
	 * @return void
	 */
	function hello_emandarine_register_elementor_locations( $elementor_theme_manager ) {
		$hook_result = apply_filters_deprecated( 'emandarine_hello_theme_register_elementor_locations', [ true ], '2.0', 'hello_emandarine_register_elementor_locations' );
		if ( apply_filters( 'hello_emandarine_register_elementor_locations', $hook_result ) ) {
			$elementor_theme_manager->register_all_core_location();
		}
	}
}
add_action( 'elementor/theme/register_locations', 'hello_emandarine_register_elementor_locations' );

// cette fonction définie la largeur par défaut du contenu du thème 
if ( ! function_exists( 'hello_emandarine_content_width' ) ) {
	/**
	 * Set default content width.
	 *
	 * @return void
	 */
	function hello_emandarine_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'hello_emandarine_content_width', 1440 );
	}
}
add_action( 'after_setup_theme', 'hello_emandarine_content_width', 0 );

// Admin notice
if ( is_admin() ) {
	require get_template_directory() . '/includes/admin-functions.php';
}

// Settings page
require get_template_directory() . '/includes/settings-functions.php';

/**
 * If Elementor is installed and active, we can load the Elementor-specific Settings & Features
*/

// Allow active/inactive via the Experiments
require get_template_directory() . '/includes/elementor-functions.php';

/**
 * Include customizer registration functions
*/ 
// cette fonction permet de charger des fonctions personnalisées pour 
// le Customizer seulement lorsque l'utilisateur est entrain de les 
// prévisualiser, afin d'améliorer les performances du site

function hello_register_customizer_functions() {
	if ( is_customize_preview() ) {
		require get_template_directory() . '/includes/customizer-functions.php';
	}
}
add_action( 'init', 'hello_register_customizer_functions' );

//  Fonction qui vérifie si le titre d'une page doit etre caché ou non
//  lors de l'utilisation du thème 

if ( ! function_exists( 'hello_emandarine_check_hide_title' ) ) {
	/**
	 * Check hide title.
	 *
	 * @param bool $val default value.
	 *
	 * @return bool
	 */
	function hello_emandarine_check_hide_title( $val ) {
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			$current_doc = Elementor\Plugin::instance()->documents->get( get_the_ID() );
			if ( $current_doc && 'yes' === $current_doc->get_settings( 'hide_title' ) ) {
				$val = false;
			}
		}
		return $val;
	}
}
add_filter( 'hello_emandarine_page_title', 'hello_emandarine_check_hide_title' );

if ( ! function_exists( 'hello_emandarine_add_description_meta_tag' ) ) {
	/**
	 * Add description meta tag with excerpt text.
	 *
	 * @return void
	 */
	function hello_emandarine_add_description_meta_tag() {
		if ( ! apply_filters( 'hello_emandarine_description_meta_tag', true ) ) {
			return;
		}

		if ( ! is_singular() ) {
			return;
		}

		$post = get_queried_object();
		if ( empty( $post->post_excerpt ) ) {
			return;
		}

		echo '<meta name="description" content="' . esc_attr( wp_strip_all_tags( $post->post_excerpt ) ) . '">' . "\n";
	}
}
add_action( 'wp_head', 'hello_emandarine_add_description_meta_tag' );




/**
 * Wrapper function to deal with backwards compatibility.
 */
// cette fonction est appelée dans le fichier header.php du thème HelloEmandarine
// et elle a pour but d'ajouter la balise <body> à l'ouverture du corps de la page 
if ( ! function_exists( 'hello_emandarine_body_open' ) ) {
	function hello_emandarine_body_open() {
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		} else {
			do_action( 'wp_body_open' );
		}
	}
}


// fonction ajoutées 
/*--------------------------------------------------------------
# ADMINISTRATION
----------------------------------------------------------------*/
/* Customisation de la page login */
function my_login_stylesheet(){
    wp_enqueue_style('custom-login', get_template_directory_uri() . '/css/login/style-login.css', array(), HELLO_EMANDARINE_VERSION);
}
add_action('login_enqueue_scripts', 'my_login_stylesheet');

function login_error_override(){
    return 'Même pas vrai !...';
}
add_filter('login_errors', 'login_error_override');

function custom_headerurl(){
    return 'https://www.emandarine.com';
}
add_filter('login_headerurl', 'custom_headerurl');

function custom_login_title(){
    return 'emandarine webmarketing';
}
add_filter( 'login_headertext', 'custom_login_title');

function wps_login_message($message){
    if (empty($message)) {
        return "<p id='nav'><a href='https://www.emandarine.com/'>evitamine de croissance</a></p>";
    } else {
        return $message;
    }
}
add_filter('login_message', 'wps_login_message');


/* Cacher la barre de gestion administrateur du tableau de bord.*/

function my_function_admin_bar(){
    return false;
}
add_filter('show_admin_bar', 'my_function_admin_bar');

/* footer text */

function remove_footer_admin(){
    echo '<a href="https://www.emandarine.com/">emandarine</a> : evitamine de croissance';
}
add_filter('admin_footer_text', 'remove_footer_admin');


/*--------------------------------------------------------------
# GRILLE ET TEMPLATE - CSS ET JS
----------------------------------------------------------------*/

// Appel des fichiers JS et CSS utiles 

// TARTE AU CITRON 
function register_tarteaucitron() {
	wp_enqueue_script('tarteaucitronjs', get_template_directory_uri().'/tarteaucitron/tarteaucitron.js', array(), HELLO_EMANDARINE_VERSION, false);
    wp_enqueue_script('tarteaucitron-config', get_template_directory_uri().'/tarteaucitron/tarteaucitron-config.js', array(), HELLO_EMANDARINE_VERSION, false);
	
}
add_action('wp_enqueue_scripts', 'register_tarteaucitron');

function register_scripts_styles() {
    // LIGHTBOX ELEMENTOR
    wp_enqueue_style('swiper', plugins_url('elementor/assets/lib/swiper/v8/css/swiper.min.css'), array(), '8.4.5', 'all');
    wp_enqueue_style('e-swiper', plugins_url('elementor/assets/css/conditionals/e-swiper.min.css'), array('swiper'), ELEMENTOR_VERSION, 'all');
    
	// FICHIER LIBRAIRIES JS ET CSS 
	wp_enqueue_style('librairies-css', get_template_directory_uri() .'/css/librairies.min.css', array(), HELLO_EMANDARINE_VERSION, 'all');
	
	// FICHIER THEME JS 
    wp_enqueue_script( 'template-js',get_template_directory_uri() .'/assets/js/template.js', array( 'jquery' ), HELLO_EMANDARINE_VERSION, true);

    // FICHIER THEME ET STYLE CSS 
    wp_enqueue_style('style-css', get_template_directory_uri() .'/style.css', array(), HELLO_EMANDARINE_VERSION, 'all');
    wp_enqueue_style('theme-css', get_template_directory_uri() .'/theme.css', array(), HELLO_EMANDARINE_VERSION, 'all');

}
add_action('wp_enqueue_scripts', 'register_scripts_styles');


/*****************************************************
  SUPPRIMER DES ELEMENTS AUTOMATIQUES DANS LE HEAD 
 *****************************************************/

remove_action('wp_head', 'rsd_link'); // windows Live Writer.
remove_action('wp_head', 'wlwmanifest_link'); // Windows Live Writer.
remove_action('wp_head', 'wp_generator'); // Version de Wordpress
remove_action('wp_head', 'start_post_rel_link'); // Liens aléatoires
remove_action('wp_head', 'index_rel_link'); // Balise rel=index
remove_action('wp_head', 'adjacent_posts_rel_link'); // Lien suivant et précédent du lien parent
remove_action('wp_head', 'wp_shortlink_wp_head'); // Balise rel=shortlink
add_filter('show_recent_comments_widget_style', '__return_false'); // Balise style des "recent comments"

/****************************************************************
  SUPPRIMER automatiquemenet les commentaires de la BDD (SPAMS)
****************************************************************/

// Fonction pour supprimer automatiquement les spams dans les commentaires
function delete_spam_comments() {
    global $wpdb;
    
    // Requête pour supprimer les commentaires marqués comme spam
    $wpdb->query("
        DELETE FROM $wpdb->comments
        WHERE comment_approved = 'spam'
    ");
    
    // Optionnel : Optimiser la table après suppression
    $wpdb->query("OPTIMIZE TABLE $wpdb->comments");
}

// Ajouter une action pour exécuter la suppression régulièrement (par exemple, toutes les 12 heures)
if (!wp_next_scheduled('delete_spam_comments_event')) {
    wp_schedule_event(time(), 'twicedaily', 'delete_spam_comments_event');
}

add_action('delete_spam_comments_event', 'delete_spam_comments');

/****************************************************************
  SITEMAP 
****************************************************************/
// fonction qui permet de générer le fichier sitemap.xml à la racine du site 

function create_sitemap() {
    if ( str_replace( '-', '', get_option( 'gmt_offset' ) ) < 10 ) {
        $tempo = '-0' . str_replace( '-', '', get_option( 'gmt_offset' ) );
    } else {
        $tempo = get_option( 'gmt_offset' );
    }
    if( strlen( $tempo ) == 3 ) { $tempo = $tempo . ':00'; }
    $postsForSitemap = get_posts( array(
        'numberposts' => -1,
        'orderby'     => 'modified',
        'post_type'   => array( 'post', 'page' ),
        'order'       => 'DESC'
    ) );
    $sitemap = '<?xml version="1.0" encoding="UTF-8"?>' . '<?xml-stylesheet type="text/xsl" href="' .
        get_template_directory_uri() . '/css/sitemap-style.xsl"?>';
    $sitemap .= "\n" . '<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
    $sitemap .= "\t" . '<url>' . "\n" .
        "\t\t" . '<loc>' . esc_url( home_url( '/' ) ) . '</loc>' .
        "\n\t\t" . '<lastmod>' . date( "Y-m-d\TH:i:s", current_time( 'timestamp', 0 ) ) . $tempo . '</lastmod>' .
        "\n\t\t" . '<changefreq>daily</changefreq>' .
        "\n\t\t" . '<priority>1.0</priority>' .
        "\n\t" . '</url>' . "\n";
    foreach( $postsForSitemap as $post ) {
        setup_postdata( $post);
        $postdate = explode( " ", $post->post_modified );
        $sitemap .= "\t" . '<url>' . "\n" .
            "\t\t" . '<loc>' . get_permalink( $post->ID ) . '</loc>' .
            "\n\t\t" . '<lastmod>' . $postdate[0] . 'T' . $postdate[1] . $tempo . '</lastmod>' .
            "\n\t\t" . '<changefreq>Weekly</changefreq>' .
            "\n\t\t" . '<priority>0.5</priority>' .
            "\n\t" . '</url>' . "\n";
    }
    $sitemap .= '</urlset>';
    $fp = fopen( ABSPATH . "sitemap.xml", 'w' );
    fwrite( $fp, $sitemap );
    fclose( $fp );
}

add_action("publish_post", "create_sitemap");
add_action("publish_page", "create_sitemap");
add_action( "save_post", "create_sitemap" );

/****************************************************************
  SUPPRIMER LES EMOJIS  
****************************************************************/

function disable_wp_emojicons()
{
	add_filter('tiny_mce_plugins', 'disable_emojicons_tinymce');
    remove_action('admin_print_styles', 'print_emoji_styles');
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('admin_print_scripts', 'print_emoji_detection_script');
    remove_action('wp_print_styles', 'print_emoji_styles');
    remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
    remove_filter('the_content_feed', 'wp_staticize_emoji');
    remove_filter('comment_text_rss', 'wp_staticize_emoji');
}

function disable_emojicons_tinymce($plugins)
{
    if (is_array($plugins)) {
        return array_diff($plugins, array('wpemoji'));
    } else {
        return array();
    }
}
add_action('init', 'disable_wp_emojicons');

/*--------------------------------------------------------------
# PAGE "REGLAGES" DANS TABLEAU BE BORD
----------------------------------------------------------------*/
/* Ajoute une page de configuration dans les settings wordpress */

function theme_settings_page()
{
    ?>
    <div class="wrap">
        <h1>Informations structure</h1>
        <form method="post" action="options.php" enctype="multipart/form-data">
            <?php
                settings_fields("contact_infos");
                do_settings_sections("theme-options");
                submit_button();
                ?>
        </form>
    </div>
<?php
}

// Ajoute cette page dans le menu
function add_theme_menu_item()
{
    add_menu_page(
        "Informations sur la structure", // titre de la page
        "Informations", // titre dans le menu
        "manage_options", // capacité de l'utilisateur nécessaire pour l'affichage (ici admin)
        "theme-panel", // slug pour le menu
        "theme_settings_page", // fonction affichant le contenu de la page
        "dashicons-warning",
        99
    ); // icône & position dans le menu
}

add_action("admin_menu", "add_theme_menu_item");

/*
 * Fonctions d'affichage des différents fields
 * créés dans la fonction display_theme_panel_fields()
 */

// Section contact

function display_companyNamePageAccueil(){
    $company_namePageAccueil = get_option('company_namePageAccueil');
    $page_on_front = get_option('page_on_front');
    
    if (!empty($page_on_front)) {
        $page = get_post($page_on_front);
        if ($page) {
            $company_namePageAccueil = $page->post_title;
        }
    }
    ?>
    <input class="regular-text" type="text" name="company_namePageAccueil" id="company_namePageAccueil" value="<?php echo $company_namePageAccueil; ?>" />
    <?php 
}

function display_companyName()
{ ?>
   <input class="regular-text" type="text" name="company_name" id="company_name" value="<?php echo get_option('company_name'); ?>" />
<?php }

function display_adresse()
{ ?>
    <input class="regular-text" type="text" name="contact_adresse" id="contact_adresse" value="<?php echo get_option('contact_adresse'); ?>" />
<?php }

function display_codepostal()
{ ?>
    <input class="regular-text" type="text" name="contact_codepostal" id="contact_codepostal" value="<?php echo get_option('contact_codepostal'); ?>" />
<?php }

function display_localite()
{ ?>
    <input class="regular-text" type="text" name="contact_localite" id="contact_localite" value="<?php echo get_option('contact_localite'); ?>" />
<?php }

function display_region()
{ ?>
    <input class="regular-text" type="text" name="contact_region" id="contact_region" value="<?php echo get_option('contact_region'); ?>" />
<?php }

function display_tel()
{ ?>
    <input class="regular-text" type="text" name="contact_tel" id="contact_tel" value="<?php echo get_option('contact_tel'); ?>" />
<?php }
function display_telurl()
{ ?>
    <input class="regular-text" type="text" name="contact_telurl" id="contact_telurl" value="<?php echo get_option('contact_telurl'); ?>" />
<?php }
function display_facebook_url()
{ ?>
    <input class="regular-text" type="text" name="contact_facebook_url" id="contact_facebook_url" value="<?php echo get_option('contact_facebook_url'); ?>" />
<?php }
function display_twitter_url()
{ ?>
    <input class="regular-text" type="text" name="contact_twitter_url" id="contact_twitter_url" value="<?php echo get_option('contact_twitter_url'); ?>" />
<?php }
function display_instagram_url()
{ ?>
    <input class="regular-text" type="text" name="contact_instagram_url" id="contact_instagram_url" value="<?php echo get_option('contact_instagram_url'); ?>" />
<?php }
function display_youtube_url()
{ ?>
    <input class="regular-text" type="text" name="contact_youtube_url" id="contact_youtube_url" value="<?php echo get_option('contact_youtube_url'); ?>" />
<?php }



// Section Métadonnées SEO
function display_keyword()
{ ?>
    <input class="regular-text" type="text" name="seo_keyword" id="seo_keyword" value="<?php echo get_option('seo_keyword'); ?>" />
<?php }
function display_description()
{ ?>
    <textarea class="regular-text" name="seo_description" id="seo_description" rows="3"><?php echo get_option('seo_description'); ?></textarea>
<?php }


// Section Autres
function display_logo()
{ 
  $logo_option = get_option('site_logo');
  if (is_wp_error($logo_option)) {
    echo $logo_option->get_error_message();
    return;
  }
  $logo_url = wp_get_attachment_url($logo_option);
  if (!empty($logo_url)) {
    ?>
    <div>
      <img class="logo" src="<?php echo esc_url($logo_url); ?>" height="50" width="auto" />
    </div>
    <?php
  }
  ?>
  <p><strong>Mettre à jour :</strong></p>
  <input type="file" name="logo" />
  <?php
}

function display_favicon()
{
    $favicon_option = get_option('site_icon');
    if (is_wp_error($favicon_option)) {
        // Si une erreur est renvoyée lors de la récupération de l'option, affichez un message d'erreur ou effectuez une autre action appropriée.
        echo $favicon_option->get_error_message();
        return;
    }
    $logo_favicon = wp_get_attachment_url($favicon_option);
  
  if (!empty($logo_favicon)) {
    ?>
    <div>
        <img class="favicon" src="<?php echo esc_url($logo_favicon);?>" height="50" width="auto" />
    </div>
    <?php
  }
  ?>
    <p><strong>Mettre à jour :</strong></p>
    <input type="file" name="favicon" />
    <?php
}


function display_analytics()
{ ?>
    <input class="regular-text" type="text" name="analytics" id="analytics" value="<?php echo get_option('analytics'); ?>" />
<?php }

function handle_logo_upload($option){
    $upload_dir = wp_upload_dir();
   
    $upload_path = $upload_dir['path'] . '/' . $_FILES['logo']["name"];
    $uploadURL= $upload_dir['url'] . '/' . $_FILES['logo']["name"];
   
    if (move_uploaded_file($_FILES["logo"]["tmp_name"], $upload_path)) {
     
        $attachment = array(
            'post_title' => $_FILES['logo']['name'],
            'post_content' => '',
            'post_status' => 'inherit',
            'post_mime_type' => $_FILES['logo']['type'],
            'post_type'=>'customize_changeset',
            'comment_status'=>'closed',
          
        );
        
        $attachment_id = wp_insert_attachment($attachment, $upload_path);
        $attach_data = wp_generate_attachment_metadata($attachment_id, $upload_path);
        wp_update_attachment_metadata($attachment_id, $attach_data);
        
        $custom_logo_data = array(
            'hello-emandarine::custom_logo' => array(
                'value' => $attachment_id, 
                'type' => 'theme_mod',
                'user_id' => get_current_user_id(), 
                'date_modified_gmt' => current_time('mysql', 1), 
            )
        );

    
        $custom_logo_json = json_encode($custom_logo_data);
        
        $post_content = $custom_logo_json;
  
        wp_update_post(array(
            'ID' => $attachment_id, 
            'post_content' => $post_content,
        ));

        update_option('site_logo', $attachment_id);
        
    } else {

    }

    return $uploadURL;
}

function handle_favicon_upload($option) {
    $upload_dirFavicon = wp_upload_dir();
   
    $upload_pathFavicon = $upload_dirFavicon['path'] . '/' . $_FILES['favicon']["name"];
  
    $uploadURLFavicon= $upload_dirFavicon['url'] . '/' . $_FILES['favicon']["name"];

    if (move_uploaded_file($_FILES["favicon"]["tmp_name"], $upload_pathFavicon)) {
            $attachmentFavicon = array(
                'post_title' => $_FILES['favicon']['name'],
                'post_content' => '',
                'post_status' => 'inherit',
                'post_mime_type' => $_FILES['favicon']['type'],
                'post_type' => 'customize_changeset',
                'comment_status' => 'closed',
            );

            $attachment_idFavicon = wp_insert_attachment($attachmentFavicon, $upload_pathFavicon);
            $attach_dataFavicon = wp_generate_attachment_metadata($attachment_idFavicon, $upload_pathFavicon);
            wp_update_attachment_metadata($attachment_idFavicon, $attach_dataFavicon);

            $custom_logo_dataFavicon = array(
                'hello-emandarine::custom_favicon' => array(
                    'value' => $attachment_idFavicon,
                    'type' => 'theme_mod',
                    'user_id' => get_current_user_id(),
                    'date_modified_gmt' => current_time('mysql', 1),
                )
            );

            $custom_logo_jsonFavicon = json_encode($custom_logo_dataFavicon);
            $post_contentFavicon = $custom_logo_jsonFavicon;

            wp_update_post(array(
                'ID' => $attachment_idFavicon,
                'post_content' => $post_contentFavicon,
            ));

            update_option('site_icon', $attachment_idFavicon);
    }


    return $uploadURLFavicon;
}


/*
 * Fonction d'ajout des fields dans la page
 * Chaque field doit être ajouté, répertorié et appartenir à une section
 */
function display_theme_panel_fields()
{
    // Section infos de contact
    // Template : "slug section", "titre section", "fonction callback (opt)", "slug page"
    add_settings_section("contact_infos", "Informations de contact", null, "theme-options");

    // Configuration de nouveaux fields
    // Template : "slug field", "titre field", "fonction d'affichage du field", "slug page", "slug section"
    add_settings_field("company_name", "Nom", "display_companyName", "theme-options", "contact_infos");
    add_settings_field("company_namePageAccueil", "Nom de la page d'accueil", "display_companyNamePageAccueil", "theme-options", "contact_infos");
    add_settings_field("contact_adresse", "Adresse", "display_adresse", "theme-options", "contact_infos");
    add_settings_field("contact_codepostal", "Code postal", "display_codepostal", "theme-options", "contact_infos");
    add_settings_field("contact_localite", "Localité", "display_localite", "theme-options", "contact_infos");
    add_settings_field("contact_region", "Région", "display_region", "theme-options", "contact_infos");
    add_settings_field("contact_tel", "Téléphone", "display_tel", "theme-options", "contact_infos");
    add_settings_field("contact_telurl", "Téléphone (pour lien)", "display_telurl", "theme-options", "contact_infos");
    add_settings_field("contact_facebook_url", "Page Facebook", "display_facebook_url", "theme-options", "contact_infos");
    add_settings_field("contact_twitter_url", "Page Twitter", "display_twitter_url", "theme-options", "contact_infos");
    add_settings_field("contact_instagram_url", "Page Instagram", "display_instagram_url", "theme-options", "contact_infos");
    add_settings_field("contact_youtube_url", "Page Youtube", "display_youtube_url", "theme-options", "contact_infos");

    // Ajout effectif des nouveaux fields
    // Template : "slug section", "slug field"
    register_setting("contact_infos", "company_name");
    register_setting("contact_infos", "company_namePageAccueil");
    register_setting("contact_infos", "contact_adresse");
    register_setting("contact_infos", "contact_codepostal");
    register_setting("contact_infos", "contact_localite");
    register_setting("contact_infos", "contact_region");
    register_setting("contact_infos", "contact_tel");
    register_setting("contact_infos", "contact_telurl");
    register_setting("contact_infos", "contact_facebook_url");
    register_setting("contact_infos", "contact_twitter_url");
    register_setting("contact_infos", "contact_instagram_url");
    register_setting("contact_infos", "contact_youtube_url");

    // Section Métadonnées SEO
    add_settings_section("seo", "Métadonnées pour le SEO", null, "theme-options");

    add_settings_field("seo_keyword", "Mots clés", "display_keyword", "theme-options", "seo");
    add_settings_field("seo_description", "Description générale", "display_description", "theme-options", "seo");

    register_setting("contact_infos", "seo_keyword");
    register_setting("contact_infos", "seo_description");

    // Section Autres
    add_settings_section("autres", "Autres informations", null, "theme-options");

    add_settings_field("logo", "Logo", "display_logo", "theme-options", "autres");
    add_settings_field("favicon", "Favicon", "display_favicon","theme-options", "autres");
    add_settings_field("analytics", "Code google analytics", "display_analytics", "theme-options", "autres");
   
    register_setting("contact_infos", "logo", "handle_logo_upload");
    register_setting("contact_infos", "favicon","handle_favicon_upload");
    register_setting("contact_infos", "analytics");

 
    // Section Gmap
    add_settings_section("gmap", "Affichage de la localisation", null, "theme-options");

    add_settings_field("url_gmap","Lien google map","display_url_gmap","theme-options","gmap");

    register_setting("contact_infos","url_gmap",[
        'sanitize_callback' => 'update_coords'
    ]);
    


}

// Initialise la fonction dans l'admin
add_action("admin_init", "display_theme_panel_fields");


/*--------------------------------------------------------------
# IMAGES
----------------------------------------------------------------*/
/* Redimensionner automatiquement l'image à la une lors de son ajout.*/

function replace_uploaded_image($image_data)
{
    // if there is no large image : return
    if (!isset($image_data['sizes']['large'])) return $image_data;

    // paths to the uploaded image and the large image
    $upload_dir = wp_upload_dir();
    $uploaded_image_location = $upload_dir['basedir'] . '/' . $image_data['file'];
    $large_image_filename = $image_data['sizes']['large']['file'];

    // Do what wordpress does in image_downsize() ... just replace the filenames ;)
    $image_basename = wp_basename($uploaded_image_location);
    $large_image_location = str_replace($image_basename, $large_image_filename, $uploaded_image_location);

    // delete the uploaded image
    unlink($uploaded_image_location);

    // rename the large image
    rename($large_image_location, $uploaded_image_location);

    // update image metadata and return them
    $image_data['width'] = $image_data['sizes']['large']['width'];
    $image_data['height'] = $image_data['sizes']['large']['height'];
    unset($image_data['sizes']['large']);

    // Check if other size-configurations link to the large-file
    foreach ($image_data['sizes'] as $size => $sizeData) {
        if ($sizeData['file'] === $large_image_filename)
            unset($image_data['sizes'][$size]);
    }
    return $image_data;
}
add_filter('wp_generate_attachment_metadata', 'replace_uploaded_image');


/* Image à la une automatique
Si pas d'image à la une, cherche la dernière image téléversée dans le post et la met en image à la une */
function autoset_featured() {
    global $post;
    if (isset($post->ID)){
        $already_has_thumb = has_post_thumbnail($post->ID);
        if (!$already_has_thumb)  {
            $attached_image = get_children( "post_parent=$post->ID&post_type=attachment&post_mime_type=image&numberposts=1" );
            if ($attached_image) {
                foreach ($attached_image as $attachment_id => $attachment) {
                    set_post_thumbnail($post->ID, $attachment_id);
                }
            }
        }
    }
}
add_action('the_post', 'autoset_featured');
add_action('save_post', 'autoset_featured');
add_action('draft_to_publish', 'autoset_featured');
add_action('new_to_publish', 'autoset_featured');
add_action('pending_to_publish', 'autoset_featured');
add_action('future_to_publish', 'autoset_featured');


/* Lier automatiquement les galeries d'images au fichier média */
add_action( 'after_setup_theme', function() {
    update_option( 'image_default_link_type', 'media' );
});

/* Ajout de l'attribut ALT pour les images quand il n'y en a pas */
    function default_image_alt($image_id){	
    	$parent_post_id = wp_get_post_parent_id( $image_id );// Récupération de l'id (nom de l'actualité ou de la page)
    	$image_title = get_the_title($image_id); // Récupération du titre de fichier d’image 
    	if($parent_post_id != 0){ // Tester si l'article ou la page est déjà nommé. 
    		$parent_title = get_the_title($parent_post_id); // Récupération du titre de post parent
    		if($parent_title != 'Brouillon auto'){ // Tester si le titre du post n'est pas par défaut
    			$alt = $parent_title . " - " . $image_title; // Si oui, la valeur d'attribut alt sera composé des titres (image et post parent)
    		}else{
    			$alt = $image_title; //Si non, la valeur de l'attribut alt sera composé de titre d'image
    		}
    		
    	}else{
    		$alt = $image_title;// Si l'image n'a pas de parent on met le titre d'image comme attribut alt
    	}
    	update_post_meta($image_id, '_wp_attachment_image_alt', $alt, ''); // Mettre a jour la valeur d'attribut alt
    }
    add_action( 'add_attachment', function( $image_ID ) {
        default_image_alt ($image_ID);
    },10);


/* ---------------------------------------------------------
# MAPS 
--------------------------------------------------------- */

// Display section Gmap

function display_url_gmap()
{ ?>
    <input class="regular-text" type="text" name="url_gmap" id="url_gmap" value="<?php echo get_option('url_gmap'); ?>" />
<?php }


// Mettre à jour la latitude et la longitude quand $url_gmap est modifié
function update_coords($url_gmap) {
    if (isset($url_gmap) && isset($_POST['url_gmap'])) {
        $array_coords = explode(',', substr(explode('/', parse_url($_POST['url_gmap'])['path'])[4], 1));
        array_pop($array_coords);

        if (isset($array_coords[0]) && isset($array_coords[1])) {
            $latitude = $array_coords[0];
            $longitude = $array_coords[1];

            update_option('latitude', $latitude, true);
            update_option('longitude', $longitude, true);
        }
    }
    return $url_gmap;
}

/*--------------------------------------------------------------
# RENOMMER "ETIQUETTES"
----------------------------------------------------------------*/

/* Changer "étiquettes" par "Mots-clés" */
add_action( 'init', 'change_cat_object' );
function change_cat_object() {
    global $wp_taxonomies;
    $labels = &$wp_taxonomies['post_tag']->labels;
    $labels->name = 'Mots-clés';
    $labels->singular_name = 'Mot-clé';
    $labels->add_new = 'Ajouter';
    $labels->add_new_item = 'Ajouter un mot-clé';
    $labels->edit_item = 'Modifier un mot-clé';
    $labels->new_item = 'Nouveau mot-clé';
    $labels->view_item = 'Voir le mot-clé';
    $labels->search_items = 'Rechercher un mot-clé';
    $labels->not_found = 'Aucun mot-clé trouvé';
    $labels->not_found_in_trash = 'Aucun mot-clé trouvé dans la corbeille';
    $labels->all_items = 'Tous les mots-clés';
    $labels->menu_name = 'Mots-clés';
    $labels->name_admin_bar = 'Mots-clés';
}



/* Sidebar */
if ( function_exists('register_sidebar') )
    register_sidebar(array('name'=>'sidebar','id' => 'sidebar'
    ));
    register_sidebar(array('name'=>'widget-1','id' => 'widget-1'
    ));
    register_sidebar(array('name'=>'widget-2','id'=> 'widget-2'
    ));
    register_sidebar(array('name'=>'widget-3','id' => 'widget-3'
    ));
    register_sidebar(array('name'=>'widget-4','id' => 'widget-4'
    ));


/* Supprimer les balises <li> dans les widgets */
function remove_li_from_widget($params) { 
    $params[0]['before_widget'] = preg_replace('/<li[^>]*>/', '', $params[0]['before_widget']); 
    $params[0]['after_widget'] = preg_replace('/<\/li>/', '', $params[0]['after_widget']); 
    return $params; 
} 
add_filter('dynamic_sidebar_params','remove_li_from_widget');


/* Donner l'autorisation aux éditeurs d'accéder aux widgets */
function wporg_simple_role_caps()
{
// Choisir le rôle (ici "editor")
    $role = get_role('editor');
// ajouter une capacité à un rôle en particulier (ici "editor")
    $role->add_cap('edit_theme_options', true);
}
add_action('init', 'wporg_simple_role_caps', 11);
function custom_admin_menu()
{
    $user = new WP_User(get_current_user_id());
    if (!empty($user->roles) && is_array($user->roles)) {
        foreach ($user->roles as $role)
            $role = $role;
    }
    if ($role === "editor") {
        remove_submenu_page('themes.php', 'themes.php');
       // remove_submenu_page('themes.php', 'widgets.php'); décommenter cette ligne pour fermer l'accès aux widgets.
        remove_submenu_page('themes.php', 'nav-menus.php'); // enlever cette ligne pour donner accès aux menus.
        $customizer_url = add_query_arg('return', urlencode(remove_query_arg(wp_removable_query_args(), wp_unslash($_SERVER['REQUEST_URI']))), 'customize.php');
        remove_submenu_page('themes.php', $customizer_url); // enlever ces deux dernières lignes pour donner l'accès à personnaliser le thème (à éviter !).
    }
}
add_action('admin_menu', 'custom_admin_menu');

/* Prévenir les fichiers elementor de passer en http à chaque mise à jour */
function fix_css_url_with_js() {
    if (is_ssl()) {
        ?>
        <style>
            body, header { visibility: hidden; }
        </style>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                var links = document.querySelectorAll('link[rel="stylesheet"]');
                links.forEach(function(link) {
                    if (link.href.startsWith('http://')) {
                        link.href = link.href.replace('http://', 'https://');
                    }
                });
            });
            window.onload = function() {
                document.body.style.visibility = "visible";
                
                var header = document.querySelector('header');
                if (header) {
                    header.style.visibility = "visible";
                }
            };
        </script>
        <?php
    }
}
add_action('wp_head', 'fix_css_url_with_js');

/*---------------------------------------------------------
# WOOCOMMERCE
-----------------------------------------------------------*/
if ( hello_emandarine_is_woocommerce_activated() ) {

/* NE PAS AFFICHER LES UGS DANS LES PAGES PRODUIT */
add_filter( 'wc_product_sku_enabled', 'wpm_remove_sku' );

function wpm_remove_sku( $enabled ) {
    // Si on est pas dans l'admin et si on est sur la page produit
    if ( !is_admin() && is_product() ) {
        return false;
    }
    return $enabled;
}

/* ENLEVER ONGLET "TELECHARGEMENTS" SUR LA PAGE "MON COMPTE"*/
add_filter( 'woocommerce_account_menu_items', 'remove_downloads_my_account', 999 );
 
function remove_downloads_my_account( $items ) {
unset($items['downloads']);
return $items;
}

/* AFFICHER "A PARTIR DE" POUR LES PRODUITS VARIABLES */
add_filter( 'woocommerce_variable_sale_price_html', 'wpm_variation_price_format', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'wpm_variation_price_format', 10, 2 );

function wpm_variation_price_format( $price, $product ) {
	//On récupère le prix min et max du produit variable
	$min_price = $product->get_variation_price( 'min', true );
	$max_price = $product->get_variation_price( 'max', true );

	// Si les prix sont différents on affiche "À partir de ..."
	if ($min_price != $max_price){
		$price = sprintf( __( 'A partir de %1$s', 'woocommerce' ), wc_price( $min_price ) );
		return $price;
	// Sinon on affiche juste le prix
	} else {
		$price = sprintf( __( '%1$s', 'woocommerce' ), wc_price( $min_price ) );
		return $price;
	}
}

/* ENLEVER LA NOTICE DE LA BOUTIQUE DANS LE FOOTER */
remove_action( 'wp_footer', 'woocommerce_demo_store' );

}

/*---------------------------------------------------------
# BOUCLE STICKY POST
-----------------------------------------------------------*/
/**
 * Order the posts in the query by sticky posts first.
 *
 * @since 1.0.0
 * @param \WP_Query $query The WordPress query instance.
 */
function query_sticky_status( $query ) {
    $sticky = get_option( 'sticky_posts' );
	$query->set('posts_per_page' , 1);
    $query->set('post__in' , $sticky);
    $query->set('ignore_sticky_posts' , 1);
}
add_action( 'elementor/query/sticky-query', 'query_sticky_status' );