<!doctype html>

<html <?php language_attributes(); ?> class="no-js">

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <?php wp_head(); ?>

  <?php 
  if (isset($post->ID)) {
    $description = get_post_meta(
      $post->ID,
      'description',
      $single = true
    );
  }
  ?>
  
  <?php $desc = get_option('seo_description'); ?>
  <meta name="keywords" content="<?php echo get_option('seo_keyword'); ?>">
  <?php if (is_front_page()) { ?>
  <meta name="description" content="<?php bloginfo('description'); ?>">
  <?php } elseif (is_single()) { ?>
  <meta name="description" content="<?php if ($description !== '') {
    echo $description;
  }
  else {
    echo wp_html_excerpt(
      $post->post_content,
      170
    );
  } ?>" />
  
  <?php } elseif (is_page()) { ?>

  <meta name="description" content="<?php if ($description !== '') {
    echo $description;
  } 
  else {
    echo wp_html_excerpt(
      $post->post_content,
      170
    );
  } ?>" />
  
  <?php } elseif (is_category()) { ?>

  <meta name="description" content="<?php echo strip_tags(
    category_description()

); ?>" />

  <?php } elseif (is_tag()) { ?>

  <meta name="description" content="<?php single_tag_title(); ?>" />

  <?php } else { ?>

  <meta name="description" content="<?php echo $desc; ?>" />

  <?php } ?>

  <?php  if ( hello_emandarine_is_woocommerce_activated() ) {?>
<!-- Open graph pour Woocommerce -->
<?php
  global $post;
  $post_type = get_post_type($post);
  $logo_option = get_option('site_logo');
  $logo_url = wp_get_attachment_url($logo_option);
 ?>

  <?php if (is_front_page())
  // for front page
    {
    ?>
    <meta property="og:type" content="business.business" />
    <meta property="og:url" content="<?= get_site_url() ?>"/>
    <meta property="og:image" content="<?php echo $logo_url; ?>"/>
    <?php
    }
    // for blog page
    elseif (is_home()){?>
      <meta property="og:type" content="article" />
      <meta property="og:url" content="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>" />
      <meta property="og:image" content="<?php echo $logo_url; ?>" />
      <?php
      }
    // for archive pages but not shop page or product category pages or blog page
    elseif (is_archive() && !is_home() && !is_product_category() && !is_shop()){
      $term = get_queried_object();

      ?>
    <meta property="og:type" content="article" />
    <meta property="og:url" content="<?php echo get_category_link($term->term_id) ; ?>" />
    <meta property="og:image" content="<?php echo $logo_url; ?>" />
    <?php
    }

    //for single post pages
    elseif (is_single() && !is_product())
    {
        if (has_post_thumbnail($post->ID))
        {
            $img_src = wp_get_attachment_url(get_post_thumbnail_id($post->ID), 'thumbnail');
        }
        //if featured image not present
        else
        {
            $img_src = $logo_url;
        }
        ?>
        <meta property="og:type" content="article" />
        <meta property="og:url" content="<?= get_the_permalink($post->ID); ?>" />
        <meta property="og:image" content="<?= $img_src; ?>"/>
        <?php
    }
    //for single product pages only
    elseif (is_product())
    {
        $img_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'thumbnail');
        ?>
        <meta property="og:type" content="product" />
        <meta property="og:url" content="<?= get_the_permalink($post->ID); ?>"/>
        <meta property="og:image" content="<?= $img_url[0]; ?>"/>
        <?php
    }
    //for product cat page
    elseif (is_product_category())
    {
      $term = get_queried_object();
      $img_src = wp_get_attachment_url(get_term_meta($term->term_id, 'thumbnail_id', true));

        if (empty($img_src))
        {
          $img_src = $logo_url;
        }
        ?>
        <meta property="og:type" content="object" />
        <meta property="og:url" content="<?= get_term_link($term->term_id, 'product_cat'); ?>" />
        <meta property="og:image" content="<?= $img_src; ?>" />
        <?php  
    }
    //for shop page
    elseif (is_shop())
    {
        ?>
        <meta property="og:type" content="object" />
        <meta property="og:url" content="<?= get_permalink(wc_get_page_id('shop')); ?>" />
        <meta property="og:image" content="<?php echo $logo_url; ?>" />
        <?php
    }
    else
    {
      if (has_post_thumbnail($post->ID))
      {
          $img_src = wp_get_attachment_url(get_post_thumbnail_id($post->ID), 'thumbnail');
      }
      //if featured image not present
      else
      {
          $img_src = $logo_url;
      }
      ?>
      <meta property="og:type" content="business.business" />
      <meta property="og:url" content="<?= get_the_permalink($post->ID); ?>" />
      <meta property="og:image" content="<?= $img_src; ?>"/>
      <?php 
  }?>
    
  <meta property="og:title" content="<?php wp_title(' | ', 'echo', 'right'); ?><?php bloginfo('name'); ?>" />
  <meta property="og:image:width" content="480px" />
  <meta property="og:image:height" content="250px" />
  <meta property="og:site_name" content="<?php bloginfo('name'); ?>" />
  <meta property="og:description" content="<?php echo get_option('seo_description'); ?>" />
  <meta property="business:contact_data:street_address" content="<?php echo get_option('contact_adresse'); ?>" />
  <meta property="business:contact_data:locality" content="<?php echo get_option('contact_localite'); ?>" />
  <meta property="business:contact_data:region" content="<?php echo get_option('contact_region'); ?>" />
  <meta property="business:contact_data:postal_code" content="<?php echo get_option('contact_codepostal'); ?>" />
  <meta property="business:contact_data:country_name" content="France" />
  <meta property="og:locale" content="fr_FR" />
<?php } else {?>

<!-- Open graph sans Woocommerce -->
<meta property="og:type" content="business.business">
  <meta property="og:title" content="<?php wp_title(' | ', 'echo', 'right'); ?><?php bloginfo('name'); ?>">
  <?php
  global $post;
  $post_type = get_post_type($post);
  $logo_option = get_option('site_logo');
  $logo_url = wp_get_attachment_url($logo_option);
  if ( !is_archive() ) { ?>
  <meta property="og:url" content="<?php the_permalink() ?>">
  <meta property="og:image"
    content="<?php echo get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : $logo_url ?>">
  <?php } else { ?>
  <meta property="og:url"
    content="<?php echo $post_type == 'post' ? get_category_link(get_query_var('cat')) : get_post_type_archive_link($post_type) ?>">
  <meta property="og:image"
    content="<?php echo $logo_url; ?>">
  <?php } ?>
  <meta property="og:image:width" content="480px">
  <meta property="og:image:height" content="250px">
  <meta property="og:site_name" content="<?php bloginfo('name'); ?>" />
  <meta property="og:description" content="<?php echo get_option('seo_description'); ?>" />
  <meta property="business:contact_data:street_address" content="<?php echo get_option('contact_adresse'); ?>">
  <meta property="business:contact_data:locality" content="<?php echo get_option('contact_localite'); ?>">
  <meta property="business:contact_data:region" content="<?php echo get_option('contact_region'); ?>">
  <meta property="business:contact_data:postal_code" content="<?php echo get_option('contact_codepostal'); ?>">
  <meta property="business:contact_data:country_name" content="France">
  <meta property="og:locale" content="fr_FR" />

  <?php } ?>

  <!-- Ajout d'une balise GeoTag avec la latitude et la longitude -->
  <meta name="geo.position" content="<?= get_option('latitude'); ?>; <?= get_option('longitude'); ?>" />
  <meta name="ICBM" content="<?= get_option('latitude'); ?>; <?= get_option('longitude'); ?> " />

  <!-- JSON-LD -->
  <script type='application/ld+json'>
    {
      "@context": "https://www.schema.org",
      "@type": "LocalBusiness",
      "name": "<?php bloginfo('name'); ?>",
      "url": "<?php echo home_url(); ?>",
      "logo": "<?php echo $logo_url; ?>",
      "image": "<?php echo $logo_url; ?>",
      "description": "<?php echo get_option('seo_description'); ?>",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "<?php echo get_option('contact_adresse'); ?>",
        "addressLocality": "<?php echo get_option('contact_localite'); ?>",
        "addressRegion": "<?php echo get_option('contact_region'); ?>",
        "postalCode": "<?php echo get_option('contact_codepostal'); ?>",
        "addressCountry": "France"
      },
      "telephone": "<?php echo get_option('contact_telurl'); ?>",
      "geo": {
        "@type": "GeoCoordinates",
        "latitude": "<?= get_option('latitude'); ?>",
        "longitude": "<?= get_option('longitude'); ?>"
      }
    }
  </script>

  <!-- Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo get_option('analytics'); ?>"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', '<?php echo get_option('analytics'); ?>');
</script>

</head>