<?php

/**
 * @author emandarine <emandarine.com>
*/

/* FONCTION INITIALISATION */

function init () {
/* Changer la valeur des variables en fonction de l'entreprise */
    $logo = ''; // nom du fichier de logo dans css > images, important : format png ou jpg
    $privacy_policy_page_title = 'Politique de confidentialité - RGPD'; // nom de la page de politique de confidentialité
    $terms_and_conditions_page_title = 'Conditions générales de vente'; // nom de la page des CGV
    $contact_page_title = 'Contact'; // nom de la page contact
    $site_url = get_site_url();
    $site_name = get_bloginfo('name');
    if (false === get_option('posts_per_page')) {// Nombre de posts par page (pour les pages archives et catégories)
        add_option('posts_per_page', 12);
    }
    $postsPerPage = get_option('posts_per_page');
    
    
    // Vérifiez l'existence des clés dans $_POST avant de les utiliser
    if(isset($_POST['submit'])) {
        $company_name = isset($_POST['company_name']) ? $_POST['company_name'] : $company_name;
        $company_namePageAccueil = isset($_POST['company_namePageAccueil']) ? $_POST['company_namePageAccueil'] : $company_namePageAccueil;
        $contact_adresse = isset($_POST['contact_adresse']) ? $_POST['contact_adresse'] :  $contact_adresse;
        $contact_codepostal = isset($_POST['contact_codepostal']) ? $_POST['contact_codepostal'] : $contact_codepostal;
        $contact_localite = isset($_POST['contact_localite']) ? $_POST['contact_localite'] : $contact_localite;
        $contact_region = isset($_POST['contact_region']) ? $_POST['contact_region'] :  $contact_region;
        $contact_tel = isset($_POST['contact_tel']) ? $_POST['contact_tel'] : $contact_tel ;
        $contact_telurl = isset($_POST['contact_telurl']) ? $_POST['contact_telurl'] : $contact_facebook_url;
        $contact_facebook_url = isset($_POST['contact_facebook_url']) ? $_POST['contact_facebook_url'] : $contact_facebook_url;
        $contact_twitter_url = isset($_POST['contact_twitter_url']) ? $_POST['contact_twitter_url'] :  $contact_twitter_url;
        $contact_instagram_url = isset($_POST['contact_instagram_url']) ? $_POST['contact_instagram_url'] : $contact_instagram_url;
        $contact_youtube_url = isset($_POST['contact_youtube_url']) ? $_POST['contact_youtube_url'] :  $contact_youtube_url;
        $contact_email = isset($_POST['contact_email']) ? $_POST['contact_email'] :   $contact_email;
        $seo_keyword = isset($_POST['seo_keyword']) ? $_POST['seo_keyword'] : $seo_keyword;
        $seo_description = isset($_POST['seo_description']) ? $_POST['seo_description'] :  $seo_description;
        $analytics = isset($_POST['analytics']) ? $_POST['analytics'] :  $analytics;
        $logo = isset($_POST['logo']) ? $_POST['logo'] : $logo ;
        $url_gmap = isset($_POST['url_gmap']) ? $_POST['url_gmap'] :  $url_gmap ;
        /* obtenir la latitude et la longitude à partir de $url_gmap */
        $array_coords = explode(',',substr(explode('/',parse_url($url_gmap)['path'])[4],1)) ;
        array_pop($array_coords) ;
        $latitude = $array_coords[0] ;
        $longitude = $array_coords[1] ;
        
        seo_options (
                    $company_name,
                    $company_namePageAccueil,
                    $contact_adresse,
                    $contact_codepostal,
                    $contact_localite, 
                    $contact_region, 
                    $contact_tel, 
                    $contact_telurl, 
                    $contact_email, 
                    $seo_keyword, 
                    $seo_description, 
                    $logo, 
                    $analytics, 
                    $contact_facebook_url, 
                    $contact_twitter_url,
                    $contact_instagram_url,
                    $contact_youtube_url,
                    $url_gmap,
                    $latitude,
                    $longitude);

        create_automatic_pages(
            $contact_page_title,
            $privacy_policy_page_title,
            $terms_and_conditions_page_title,
            $company_namePageAccueil,
            $contact_adresse,
            $contact_codepostal,
            $contact_localite,
            $contact_tel,
            $contact_telurl,
            get_site_url(),
            get_bloginfo('name')
        );

        set_privacy_policy_page($privacy_policy_page_title);

        if ( hello_emandarine_is_woocommerce_activated() ) {
            set_terms_and_conditions_page ($terms_and_conditions_page_title);
        }
        setUserDefaultRole('editor');
        delete_post ('Bonjour tout le monde !');
        delete_post ("Page d’exemple");
        delete_post ('Politique de confidentialité');
        change_front_page ($company_namePageAccueil);
        media_settings_init();
        init_category_and_tags();
        remove_default_plugins_themes();
        change_tagline ($seo_description);
        add_default_category();
        change_posts_per_page ($postsPerPage);
        set_permalink();
    }

}
add_action('admin_init', 'init');

// remplit les options de SEO propres au thème
function seo_options ($company_name,$company_namePageAccueil, $contact_adresse, $contact_codepostal, $contact_localite, $contact_region, $contact_tel, $contact_telurl, $contact_email, $seo_keyword, $seo_description, $logo, $analytics, $contact_facebook_url, $contact_twitter_url, $contact_instagram_url, $contact_youtube_url, $url_gmap, $latitude, $longitude) {  
    // Vérification et mise à jour de chaque option uniquement si une valeur est fournie
    if (!empty($company_name)) update_option('company_name', $company_name, true);
    if (!empty($company_namePageAccueil)) update_option('company_namePageAccueil', $company_namePageAccueil, true);
    if (!empty($contact_adresse)) update_option('contact_adresse', $contact_adresse, true);
    if (!empty($contact_codepostal)) update_option('contact_codepostal', $contact_codepostal, true);
    if (!empty($contact_localite)) update_option('contact_localite', $contact_localite, true);
    if (!empty($contact_region)) update_option('contact_region', $contact_region, true);
    if (!empty($contact_tel)) update_option('contact_tel', $contact_tel, true);
    if (!empty($contact_telurl)) update_option('contact_telurl', $contact_telurl, true);
    if (!empty($contact_email)) update_option('contact_email', $contact_email, true);
    if (!empty($contact_facebook_url)) update_option('contact_facebook_url', $contact_facebook_url, true);
    if (!empty($contact_twitter_url)) update_option('contact_twitter_url', $contact_twitter_url, true);
    if (!empty($contact_instagram_url)) update_option('contact_instagram_url', $contact_instagram_url, true);
    if (!empty($contact_youtube_url)) update_option('contact_youtube_url', $contact_youtube_url, true);
    if (!empty($seo_keyword)) update_option('seo_keyword', $seo_keyword, true);
    if (!empty($seo_description)) update_option('seo_description', $seo_description, true);
    if (!empty($logo)) update_option('logo', $logo, true);
    if (!empty($analytics)) update_option('analytics', $analytics, true);

    // Mise à jour des options de carte uniquement si l'URL de la carte est fournie
    if (!empty($url_gmap)) update_option('url_gmap', $url_gmap, true);
    if (!empty($latitude)) update_option('latitude', $latitude, true);
    if (!empty($longitude)) update_option('longitude', $longitude, true);
}

// initialise la taille des images
function media_settings_init() {
    // Vérifie si les options existent, sinon, utilisez les valeurs par défaut
    $thumbnail_size_w = get_option('thumbnail_size_w', 480);
    $thumbnail_size_h = get_option('thumbnail_size_h', 250);
    $medium_size_w = get_option('medium_size_w', 620);
    $medium_size_h = get_option('medium_size_h', 800);
    $large_size_w = get_option('large_size_w', 2000);
    $large_size_h = get_option('large_size_h', 2000);

    // Mettez à jour les options en utilisant les valeurs par défaut si elles n'existent pas
    update_option('thumbnail_size_w', $thumbnail_size_w);
    update_option('thumbnail_size_h', $thumbnail_size_h);
    update_option('medium_size_w', $medium_size_w);
    update_option('medium_size_h', $medium_size_h);
    update_option('large_size_w', $large_size_w);
    update_option('large_size_h', $large_size_h);
}


// initialise le préfixe des catégories et la base des étiquettes dans réglages->Permaliens->Falcultatif
function init_category_and_tags () {
    update_option( 'category_base', '.', true ); // Préfixe des catégories
    update_option( 'tag_base', '.', true ); // Base des étiquettes
}

// enlève les 2 derniers thèmes de base & les plugins
function remove_default_plugins_themes () {
    delete_theme('twentytwentythree');
    delete_theme('twentytwentytwo');
    delete_plugins(array('hello.php'));
}

// Change le "slogan" du site (description)
function change_tagline ($newTagline) {
	update_option( 'blogdescription', $newTagline ,true );
}

// Ajoute une catégorie par défaut pour les articles
function add_default_category () {
    wp_insert_category( array(
        'cat_name' => 'Actualités',
        'category_description' => 'Actualités',
        'category_nicename' =>'actualités',
        'cat_ID' => 1,
    ));
}

// Change le nombre de posts visibles par page (pages archives ou catégories)
function change_posts_per_page ($postsPerPage) {
	update_option( 'posts_per_page', $postsPerPage ,true );
}

// Initialise les permaliens
function set_permalink() {
    global $wp_rewrite;
    // Vérifiez si la structure de permalien est déjà définie
    $permalink_structure = get_option('permalink_structure');
    if (empty($permalink_structure)) {
        // Si la structure de permalien n'est pas encore définie, définissez-la par défaut
        $wp_rewrite->set_permalink_structure('/%category%/%postname%/');
    }
}

// Crée automatiquement une page ou un article
function create_page ($title,$content,$post_type,$parent = 0) {
    // on vérifie qu'une page n'a pas déjà été créée avec le même titre
    $page = get_page_by_title( $title, OBJECT, $post_type );
    $cat = get_cat_ID( 'Actualités' );
    if (!isset($page)) {
        $post_data = array(
            'post_content'  => $content,
            'post_title'    => $title,
            'post_type' 	=> $post_type,
            'post_category' => array($cat),
            'post_status'   => 'publish',
            'post_parent'   => $parent,
        );
        wp_insert_post( $post_data);
    } else {
        return;
    }
}

function create_automatic_pages ($contact_page_title, $privacy_policy_page_title, $terms_and_conditions_page_title, $company_name,$contact_adresse,$contact_codepostal,$contact_localite,$contact_tel,$contact_telurl,$site_url, $site_name) {

    // exemple de page

    // create_page("exemple page",'','page');

    // exemple d'article

    // create_page("exemple article",'','post');

    // page de contact

    create_page($contact_page_title,'','page');

    // page d'accueil

    create_page($company_name,'','page');

    // mentions légales

    create_page('Mentions légales', '

    <!-- wp:heading -->

    <h2>Responsabilité du site</h2>

    <!-- /wp:heading -->



    <!-- wp:paragraph -->

    <p>Raison sociale : <strong>' . $company_name . '</strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>SARL - Société A Responsabilité Limitée</p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>Au capital de xxx €</p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>Dont le siège social est situé <strong>' . $contact_adresse . ' - '. $contact_codepostal. ' '.$contact_localite.'</strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>Immatriculée au Registre du Commerce et des Sociétés de <strong>ville d\'immatriculation</strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>Sous le N° de Siret : <strong>n° de siret</strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>N° T.V.A Intracommunautaire : <strong>n° de TVA</strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>Téléphone : <strong><a href="tel:'. $contact_telurl .'" title="Communication directe">' .$contact_tel .'</a></strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>Site : <strong><a href="' . $site_url .'">' . $site_name.'</a></strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:heading -->

    <h2>Editeur du site :</h2>

    <!-- /wp:heading -->



    <!-- wp:paragraph -->

    <p><strong><a href="https://www.emandarine.com">emandarine</a></strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>384 avenue de Nantes, Poitiers, France</p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>+33 (0) 9 50 76 74 42 </p>

    <!-- /wp:paragraph -->



    <!-- wp:heading -->

    <h2>Hébergeur du site :</h2>

    <!-- /wp:heading -->



    <!-- wp:paragraph -->

    <p><strong>OVH</strong></p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>2 rue Kellermann, 59100 Roubaix</p>

    <!-- /wp:paragraph -->



    <!-- wp:paragraph -->

    <p>+33 8 203 203 63</p>

    <!-- /wp:paragraph -->

    ','page');

    

    // post sur l'ouverture du site

    create_page('Ouverture du site web',"

    <!-- wp:paragraph -->

    <p>Nous avons le plaisir de vous informer de l'ouverture de notre site web ce " .  date_i18n('l j F Y') . ".</p>

    <!-- /wp:paragraph -->

    ",'post');

    

    // page de politique de confidentialité

    create_page($privacy_policy_page_title,"

    <!-- wp:heading -->

    <h2>Définitions :</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>L'Éditeur :</strong> La personne, physique ou morale, qui édite les services de communication au public en ligne.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Le Site :</strong> L'ensemble des sites, pages Internet et services en ligne proposés par l'Éditeur.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>L'Utilisateur :</strong> La personne utilisant le Site et les services.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Nature des données collectées</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Dans le cadre de l'utilisation des Sites, l'Éditeur est susceptible de collecter les catégories de données suivantes concernant ses Utilisateurs :</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Données de connexion (adresses IP, journaux d'événements...)</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Communication des données personnelles à des tiers</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Pas de communication à des tiers</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Vos données ne font l'objet d'aucune communication à des tiers. Vous êtes toutefois informés qu'elles pourront être divulguées en application d'une loi, d'un règlement ou en vertu d'une décision d'une autorité réglementaire ou judiciaire compétente.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Information préalable pour la communication des données personnelles à des tiers en cas de fusion / absorption</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Information préalable et possibilité d’opt-out avant et après la fusion / acquisition</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Dans le cas où nous prendrions part à une opération de fusion, d’acquisition ou à toute autre forme de cession d’actifs, nous nous engageons à garantir la confidentialité de vos données personnelles et à vous informer avant que celles-ci ne soient transférées ou soumises à de nouvelles règles de confidentialité.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Finalité de la réutilisation des données personnelles collectées</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>L'élaboration de statistiques commerciales</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Agrégation des données</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Agrégation avec des données non personnelles</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Nous pouvons publier, divulguer et utiliser les informations agrégées (informations relatives à tous nos Utilisateurs ou à des groupes ou catégories spécifiques d'Utilisateurs que nous combinons de manière à ce qu'un Utilisateur individuel ne puisse plus être identifié ou mentionné) et les informations non personnelles à des fins d'analyse du secteur et du marché, de profilage démographique, à des fins promotionnelles et publicitaires et à d'autres fins commerciales.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Agrégation avec des données personnelles disponibles sur les comptes sociaux de l'Utilisateur</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Si vous connectez votre compte à un compte d’un autre service afin de faire des envois croisés, ledit service pourra nous communiquer vos informations de profil, de connexion, ainsi que toute autre information dont vous avez autorisé la divulgation. Nous pouvons agréger les informations relatives à tous nos autres Utilisateurs, groupes, comptes, aux données personnelles disponibles sur l’Utilisateur.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Collecte des données d'identité</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Consultation libre</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>La consultation du Site ne nécessite pas d'inscription ni d'identification préalable. Elle peut s'effectuer sans que vous ne communiquiez de données nominatives vous concernant (nom, prénom, adresse, etc.). Nous ne procédons à aucun enregistrement de données nominatives pour la simple consultation du Site.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Collecte des données d'identification</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Utilisation de l'identifiant de l’utilisateur uniquement pour l’accès aux services</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Nous utilisons vos identifiants électroniques seulement pour et pendant l'exécution du contrat.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Collecte des données du terminal</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Collecte des données de profilage et des données techniques à des fins de fourniture du service</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Certaines des données techniques de votre appareil sont collectées automatiquement par le Site. Ces informations incluent notamment votre adresse IP, fournisseur d'accès à Internet, configuration matérielle, configuration logicielle, type et langue du navigateur… La collecte de ces données est nécessaire à la fourniture des services.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Collecte des données techniques à des fins publicitaires, commerciales et statistiques</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Les données techniques de votre appareil sont automatiquement collectées et enregistrées par le Site, à des fins publicitaires, commerciales et statistiques. Ces informations nous aident à personnaliser et à améliorer continuellement votre expérience sur notre Site. Nous ne collectons ni ne conservons aucune donnée nominative (nom, prénom, adresse…) éventuellement attachée à une donnée technique. Les données collectées sont susceptibles d’être revendues à des tiers.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Cookies</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Durée de conservation des cookies</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Conformément aux recommandations de la CNIL, la durée maximale de conservation des cookies est de 13 mois au maximum après leur premier dépôt dans le terminal de l'Utilisateur, tout comme la durée de la validité du consentement de l’Utilisateur à l’utilisation de ces cookies. La durée de vie des cookies n’est pas prolongée à chaque visite. Le consentement de l’Utilisateur devra donc être renouvelé à l'issue de ce délai.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Finalité cookies</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Les cookies peuvent être utilisés pour des fins statistiques notamment pour optimiser les services rendus à l'Utilisateur, à partir du traitement des informations concernant la fréquence d'accès, la personnalisation des pages ainsi que les opérations réalisées et les informations consultées.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Vous êtes informé que l'Éditeur est susceptible de déposer des cookies sur votre terminal. Le cookie enregistre des informations relatives à la navigation sur le service (les pages que vous avez consultées, la date et l'heure de la consultation…) que nous pourrons lire lors de vos visites ultérieures.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Droit de l'Utilisateur de refuser les cookies</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Vous reconnaissez avoir été informé que l'Éditeur peut avoir recours à des cookies. Si vous ne souhaitez pas que des cookies soient utilisés sur votre terminal, la plupart des navigateurs vous permettent de désactiver les cookies en passant par les options de réglage.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Conservation des données techniques</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Durée de conservation des données techniques</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Les données techniques sont conservées pour la durée strictement nécessaire à la réalisation des finalités visées ci-avant.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Délai de conservation des données personnelles et d'anonymisation</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Conservation des données pendant la durée de la relation contractuelle</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Conformément à l'article 6-5° de la loi n°78-17 du 6 janvier 1978 relative à l'informatique, aux fichiers et aux libertés, les données à caractère personnel faisant l'objet d'un traitement ne sont pas conservées au-delà du temps nécessaire à l'exécution des obligations définies lors de la conclusion du contrat ou de la durée prédéfinie de la relation contractuelle.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Conservation des données anonymisées au delà de la relation contractuelle / après la suppression du compte</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Nous conservons les données personnelles pour la durée strictement nécessaire à la réalisation des finalités décrites dans les présentes CGU. Au-delà de cette durée, elles seront anonymisées et conservées à des fins exclusivement statistiques et ne donneront lieu à aucune exploitation, de quelque nature que ce soit.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Suppression des données après suppression du compte</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Des moyens de purge de données sont mis en place afin d'en prévoir la suppression effective dès lors que la durée de conservation ou d'archivage nécessaire à l'accomplissement des finalités déterminées ou imposées est atteinte. Conformément à la loi n°78-17 du 6 janvier 1978 relative à l'informatique, aux fichiers et aux libertés, vous disposez par ailleurs d'un droit de suppression sur vos données que vous pouvez exercer à tout moment en prenant contact avec l'Éditeur.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Suppression des données après 3 ans d'inactivité</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Pour des raisons de sécurité, si vous ne vous êtes pas authentifié sur le Site pendant une période de trois ans, vous recevrez un e-mail vous invitant à vous connecter dans les plus brefs délais, sans quoi vos données seront supprimées de nos bases de données.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Suppression du compte</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Suppression du compte à la demande</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>L'Utilisateur a la possibilité de supprimer son Compte à tout moment, par simple demande à l'Éditeur OU par le menu de suppression de Compte présent dans les paramètres du Compte le cas échéant.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p><strong>Suppression du compte en cas de violation des CGU</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>En cas de violation d'une ou de plusieurs dispositions des CGU ou de tout autre document incorporé aux présentes par référence, l'Éditeur se réserve le droit de mettre fin ou restreindre sans aucun avertissement préalable et à sa seule discrétion, votre usage et accès aux services, à votre compte et à tous les Sites.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Indications en cas de faille de sécurité décelée par l'Éditeur</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Information de l'Utilisateur en cas de faille de sécurité</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Nous nous engageons à mettre en œuvre toutes les mesures techniques et organisationnelles appropriées afin de garantir un niveau de sécurité adapté au regard des risques d'accès accidentels, non autorisés ou illégaux, de divulgation, d'altération, de perte ou encore de destruction des données personnelles vous concernant. Dans l'éventualité où nous prendrions connaissance d'un accès illégal aux données personnelles vous concernant stockées sur nos serveurs ou ceux de nos prestataires, ou d'un accès non autorisé ayant pour conséquence la réalisation des risques identifiés ci-dessus, nous nous engageons à :</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:list -->

    <ul><li>Vous notifier l'incident dans les plus brefs délais ;</li><li>Examiner les causes de l'incident et vous en informer ;</li><li>Prendre les mesures nécessaires dans la limite du raisonnable afin d'amoindrir les effets négatifs et préjudices pouvant résulter dudit incident</li></ul>

    <!-- /wp:list -->

    

    <!-- wp:paragraph -->

    <p><strong>Limitation de la responsabilité</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>En aucun cas les engagements définis au point ci-dessus relatifs à la notification en cas de faille de sécurité ne peuvent être assimilés à une quelconque reconnaissance de faute ou de responsabilité quant à la survenance de l'incident en question.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Transfert des données personnelles à l'étranger</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Pas de transfert en dehors de l'Union européenne</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>L'Éditeur s'engage à ne pas transférer les données personnelles de ses Utilisateurs en dehors de l'Union européenne.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Modification des CGU et de la politique de confidentialité</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>En cas de modification des présentes CGU, engagement de ne pas baisser le niveau de confidentialité de manière substantielle sans l'information préalable des personnes concernées</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Nous nous engageons à vous informer en cas de modification substantielle des présentes CGU, et à ne pas baisser le niveau de confidentialité de vos données de manière substantielle sans vous en informer et obtenir votre consentement.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:heading -->

    <h2>Droit applicable et modalités de recours</h2>

    <!-- /wp:heading -->

    

    <!-- wp:paragraph -->

    <p><strong>Application du droit français (législation CNIL) et compétence des tribunaux</strong></p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>Les présentes CGU et votre utilisation du Site sont régies et interprétées conformément aux lois de France, et notamment à la Loi n° 78-17 du 6 janvier 1978 relative à l'informatique, aux fichiers et aux libertés. Le choix de la loi applicable ne porte pas atteinte à vos droits en tant que consommateur conformément à la loi applicable de votre lieu de résidence. Si vous êtes un consommateur, vous et nous acceptons de se soumettre à la compétence non-exclusive des juridictions françaises, ce qui signifie que vous pouvez engager une action relative aux présentes CGU en France ou dans le pays de l'UE dans lequel vous vivez. Si vous êtes un professionnel, toutes les actions à notre encontre doivent être engagées devant une juridiction en France.</p>

    <!-- /wp:paragraph -->

    

    <!-- wp:paragraph -->

    <p>En cas de litige, les parties chercheront une solution amiable avant toute action judiciaire. En cas d'échec de ces tentatives, toutes contestations à la validité, l'interprétation et / ou l'exécution des présentes CGU devront être portées même en cas de pluralité des défendeurs ou d'appel en garantie, devant les tribunaux français.</p>

    <!-- /wp:paragraph -->" ,'page');

    // créer les conditions générales de vente
    if ( hello_emandarine_is_woocommerce_activated() ) {
    create_page($terms_and_conditions_page_title,'
    <!-- wp:heading -->
    <h2>Application et opposabilité des conditions générales de vente</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Les présentes conditions générales de vente sont portées à la connaissance de chaque client pour lui permettre de passer commande. Les présentes conditions s’appliquent pendant toute la durée de leur mise en ligne par ' . $company_name .'.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Le client reconnaît avoir pris connaissance, au moment de la passation de commande, des conditions générales de vente énoncées sur le site <strong> <a href="'. $site_url .'">'. $site_name .'</a></strong>. Toute passation de commande vaut acceptation des présentes conditions générales sans aucune réserve.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Les présentes conditions générales de vente régissent les relations contractuelles entre ' . $company_name .' et son client, les deux parties les acceptant sans réserve.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Ces conditions générales de vente prévaudront sur toutes autres conditions figurant dans tout autre document, sauf dérogation préalable, expresse et écrite. Toute condition contraire posée par le client sera donc, à défaut d’acceptation expresse, inopposable à ' . $company_name .' quel que soit le moment où elle aura pu être portée à sa connaissance.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Les produits ' . $company_name .'</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Nos offres de produits et de prix sont valables pour la durée de leur mise en ligne, sauf précision contraire sur la fiche produite.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>' . $company_name .' vérifie les informations mises en ligne et concernant les caractéristiques essentielles des produits. Cependant, compte tenu de la nature même des procédés de fabrication, de légères variations de dimensions, poids et couleur peuvent exister entre l’information écrite et visuelle et le produit livré. Ceci n’altère en rien sa qualité et confirme son caractère unique. Les photographies présentes sur <strong><a href="'. $site_url .'">'. $site_name .'</a></strong> servent à illustrer les produits vendus et ne sont en aucun cas contractuelles.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Les prix</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Les prix figurant sur <strong><a href="'. $site_url .'">'. $site_name .'</a></strong> sont exprimés en euro, hors frais de transports. ' . $company_name .' se réserve la possibilité de modifier ses prix à tout moment : les produits sont facturés sur la base des tarifs en vigueur au moment de la validation de la commande sous réserve de disponibilité. Les produits demeurent la propriété du vendeur jusqu’au complet paiement du prix .</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Il est néanmoins précisé que le simple fait d’ajouter un produit dans le panier ne vaut pas validation de la commande car le produit peut devenir indisponible entre le moment de l’ajout dans le panier et la validation de la commande par le client.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Les commandes</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Le client qui souhaite acheter un produit via <strong><a href="'. $site_url .'">'. $site_name .'</a></strong> doit suivre le processus de commande en ligne qui comprend une phase d’identification, une phase de vérification et de validation des produits choisis, une phase de paiement dans les conditions prévues et une phase de confirmation de la commande et du règlement.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>La confirmation de la commande entraîne l’acceptation des présentes conditions de vente, la reconnaissance d’en avoir parfaite connaissance et la renonciation à se prévaloir de ses propres conditions d’achat ou d’autres conditions. L’ensemble des données fournies ainsi que la confirmation enregistrée vaudront preuve de la transaction. ' . $company_name .' transmettra par courrier électronique confirmation de la commande enregistrée qui vaudra acceptation de la commande.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>La commande sera traitée et envoyée dans les délais indiqués sur la page «livraison» du site, dès réception du paiement total de la commande.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Les commandes indiquant une adresse en boîte postale ne pourront être prises en compte.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>' . $company_name .' informera le client par email, par téléphone ou par courrier des éventuelles ruptures de stocks pouvant affecter la commande et dans ce cas, aucun remboursement ne sera effectué mais un avoir du montant de la commande sera crédité au client.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>' . $company_name .' se réserve le droit de demander au client des justificatifs d’identité pour confirmer définitivement la livraison de la commande. Cette vérification n’est pas systématique. Lorsqu’elle survient, le client en est informé par email, dans les 24h (hors dimanche et jours fériés) suivant la validation de la commande.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>' . $company_name .' se réserve le droit d’annuler toute commande d’un client avec lequel existerait un litige relatif au paiement d’une commande antérieure.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Livraison</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Les livraisons sont faites à l’adresse indiquée dans la commande, dans le cadre de la limite géographique précisée. Les colis sont livrés selon les frais de livraison énoncés lors de la commande et dans les délais correspondants à leur zone géographique.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>' . $company_name .' se dégage de toute responsabilité en cas d’inexécution du contrat dû à un cas de force majeure (grève, incendie, inondation…).</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Rétractation</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Le client dispose d’un délai de sept jours ouvrés pour exercer son droit de rétractation sans avoir à justifier de motifs ni à payer de pénalités, à l’exception, le cas échéant, des frais de retour. Le délai mentionné précédemment court à compter de la réception des articles.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Le droit de rétractation peut être exercé en contactant ' . $company_name .' par l’intermédiaire du formulaire situé dans la rubrique <a href=" '. esc_url( get_permalink( get_page_by_title( $contact_page_title ) ) ) .'"><strong>'. $contact_page_title. '</strong></a></p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>En cas d’exercice du droit de rétractation dans le délai susmentionné, seul le prix du ou des produits achetés sera remboursé, les frais de retour restent à la charge du client.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Les retours des produits sont à effectuer dans leur état d’origine et complets (emballage, accessoires, notice…) de sorte qu’ils puissent être recommercialisés à l’état neuf ; ils doivent si possible être accompagnés d’une copie du justificatif d’achat. Le remboursement est dû dans un délai maximum de 30 jours.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>En cas d’échange ou remboursement, merci de renvoyer vos produits à l’adresse suivante : '. $company_name .' - '. $contact_adresse .' - ' .$contact_codepostal.' '. $contact_localite .'</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Paiement</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Le prix est éligible à la commande. Les paiements en ligne sont réalisés par système sécurisé afin qu’aucun tiers ne puisse avoir accès aux données transmises à cette occasion.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>La commande réglée comptant du client peut l’être uniquement par Carte Bancaire (Carte Bleue, Visa ou Mastercard).</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Service clientèle</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Pour toute question ou information, vous pouvez nous contacter :</p>
    <!-- /wp:paragraph -->

    <!-- wp:list -->
    <ul><li>soit par l’intermédiaire du formulaire situé dans la rubrique <a href=" '. esc_url( get_permalink( get_page_by_title( $contact_page_title ) ) ) .'"><strong>'. $contact_page_title. '</strong></a></li><li>soit par téléphone au <a href="tel:' . $contact_telurl . '"><strong>' . $contact_tel . '</strong></a></li></ul>
    <!-- /wp:list -->

    <!-- wp:heading -->
    <h2>Litiges et réclamations</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Le présent contrat est soumis au droit français et limité à la France Métropolitaine.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Les réclamations ou contestations seront toujours reçues avec une bienveillance attentive, la bonne foi étant toujours présumée chez celui qui prend la peine d’exercer le litige.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>A la réception des produits, le client doit s’assurer de la conformité de la livraison avec sa commande. Les dommages éventuels doivent faire l’objet de réserves précises, datées et signées, sur le bordereau de livraison.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Toute réclamation devra être faite dans un délai maximum de 48 heures après réception, au service clients de ' . $company_name .', par lettre recommandée avec accusé de réception : ' . $company_name .' - '. $contact_adresse .' - ' .$contact_codepostal.' '. $contact_localite .'</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Vous pouvez également nous contacter par email via le formulaire situé dans la rubrique <a href=" '. esc_url( get_permalink( get_page_by_title( $contact_page_title ) ) ) .'"><strong>'. $contact_page_title. '</strong></a>.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Passé ce délai, aucune réclamation ne sera prise en compte.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Cette réclamation devra être motivée et accompagnée des justificatifs du préjudice subi (lettre de transport, photo du colis reçu …). Après l’analyse et l’acceptation de la réclamation par ' . $company_name .', le client pourra choisir entre le remboursement de sa commande ou une nouvelle livraison.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>En cas de litige, le client s’adressera par priorité à l’entreprise pour obtenir une solution amiable. A défaut, les litiges seront portés devant les tribunaux compétents.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Retours</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Tout retour de produit doit faire l’objet d’un accord formel entre ' . $company_name .' et le client et être retourné dans les 48 heures suivant l’accord. Passé ce délai, aucun retour ne pourra être pris en compte.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Toute reprise acceptée par ' . $company_name .', dans le cas d’un vice apparent ou de non-conformité des produits livrés, qui sera constaté par ' . $company_name .', permettra au client d’obtenir le remplacement gratuit ou la restitution d’un avoir à son profit, à l’exclusion de toute autre indemnité ou dommages et intérêts.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Informations légales</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Les mineurs n’ont pas la capacité de contracter. La collecte des données auprès des mineurs doit faire l’objet d’une information de l’autorité parentale. Le renseignement des informations nominatives collectées aux fins de la vente à distance est obligatoire, ces informations étant indispensables pour le traitement et l’acheminement des commandes, l’établissement des factures et contrats de garantie. Le défaut de renseignement entraîne la non validation de la commande.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Le client dispose (article 34 de la loi du 6 janvier 1978) d’un droit d’accès, de modification, de rectification et de suppression des données qui le concernent, qu’il peut exercer auprès de ' . $company_name .'.</p>
    <!-- /wp:paragraph -->

    <!-- wp:heading -->
    <h2>Politique de discrétion</h2>
    <!-- /wp:heading -->

    <!-- wp:paragraph -->
    <p>Les données personnelles sont protégées selon la loi Informatique et Libertés, et ne sont pas utilisées par des tiers : le client ne peut recevoir des e-mails commerciaux que si celui-ci les a demandés. A tout moment, le client peut modifier ses coordonnées directement sur <strong><a href="'. $site_url .'">'. $site_name .'</a></strong>.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Toutes ces données peuvent être modifiées par le client. Celui-ci est en droit de demander sa suppression du fichier de ' . $company_name .'.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>Ces informations permettent de faciliter encore davantage au client l’utilisation du site <strong><a href="'. $site_url .'">'. $site_name .'</a></strong>, en lui évitant par exemple de procéder à de multiples saisies, et de profiter pleinement de toutes les fonctionnalités que le site offre au client.</p>
    <!-- /wp:paragraph -->

    <!-- wp:paragraph -->
    <p>L’adresse du client est utile au moment de la commande afin de lui adresser sa facture et sa commande dans les délais. Les coordonnées téléphoniques du client permettent aux livreurs et au service clients de ' . $company_name .' de contacter le client pour le suivi de sa commande.<br>L’adresse mail du client permet à ' . $company_name .' de confirmer les commandes du client, ainsi que toutes les réponses qui seraient données au téléphone par le service clients.<br>Les informations bancaires du client (numéro de carte bancaire, date de validité) sont cryptées par le système SSL. Elles sont inaccessibles par un tiers.</p>
    <!-- /wp:paragraph -->
    ','page');
    }

}



// change la page d'accueil

function change_front_page ($company_namePageAccueil) {

    $homepage = get_page_by_title($company_namePageAccueil);
    
    if ( $homepage ) {
        update_option( 'page_on_front', $homepage->ID );
        update_option( 'show_on_front', 'page' );

        
    }
}

// Assigne la page de politique de confidentialité au statut "page de politique de confidentialité"
function set_privacy_policy_page ($privacy_policy_page_title) {
    $privacy_policy_page = get_page_by_title($privacy_policy_page_title);
    if ( $privacy_policy_page ) {
        update_option( 'wp_page_for_privacy_policy', $privacy_policy_page->ID );
    }
}

// Assigne la page des CGV au statut "page des conditions générales de vente"
function set_terms_and_conditions_page ($terms_and_conditions_page_title) {
    $terms_and_conditions_page = get_page_by_title($terms_and_conditions_page_title);
    if ( $terms_and_conditions_page ) {
        update_option( 'woocommerce_terms_page_id', $terms_and_conditions_page->ID );
    }
}

// Assigne un rôle par défaut pour la création d'un nouveau compte
function setUserDefaultRole($newDefaultRole){
    update_option('default_role',$newDefaultRole);
}

// Supprime une page
function delete_post ($postTitle){
    $page = get_page_by_title( $postTitle, OBJECT, array('page','post'));
    if (isset($page)){
        $post_id = $page->ID;
        wp_delete_post($post_id, false );
    }
}