<?php 

/*******************************************************************************************************************************/
/***************************************************  BALISES DYNAMIQUES   *****************************************************/ 
/*******************************************************************************************************************************/

/**
* Enregistrement d'une balise dynamique 'telephone' pour Elementor.
* 
* Ce code enregistre une balise dynamique personnalisée pour Elementor, permettant 
* d'afficher le numéro de téléphone configuré dans l'option 'contact_tel' et de l'actualiser a chaque changement.
* La balise est disponible dans Elementor dans les widgets et les modèles  
*/

add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    
    // définition d'une classe personnalisée pour la balise dynamique 'telephone'
    class Elementor_telephone_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'telephone';
        }

        public function get_title() {
            return __( 'Téléphone', 'text-domain' );
        }
        
       /* méthode qui retourne le groupe de la balise dynamique, ici 'base'
        *  cela permet de classer la balise dans un groupe spécifique de l'interface Elementor 
        */
        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = [] ) {

            // récupération du numéro de téléphone à partir de l'option 'contact_tel' du formulaire 'informations'
            $numeroTelephone = get_option( 'contact_tel' );
            return $numeroTelephone;
        }
    }

    // enregistrement de la balise dynamique 'telephone' 
    $dynamic_tags->register_tag( 'Elementor_telephone_Tag' );
} );

/**
* Ajoute une balise dynamique dans la catégorie URL qui crée un lien d'appel.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui permet de générer
* un lien d'appel téléphonique. La balise est disponible dans l'interface Elementor, dans la
* catégorie URL, pour être utilisée dans les widgets et les modèles.
*/
add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_telephone_url_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'numeroDeTelephone';
        }

        public function get_title() {
            return __( 'Téléphone URL', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::URL_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $phone_number = get_option( 'contact_telurl' );
            return 'tel:' . $phone_number;
        }
    
    }

    $dynamic_tags->register_tag( 'Elementor_telephone_url_Tag' );
} );

/**
* Balise dynamique contenant l'adresse.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui affiche l'adresse.
* La valeur de la balise est récupérée à partir de l'option 'contact_adresse' et s'actualise
* automatiquement lorsque cette option est modifiée.
* La balise est disponible dans l'interface Elementor, dans la catégorie Texte, pour être utilisée
* dans les widgets et les modèles.
*/

add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_Adress_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'adresse';
        }

        public function get_title() {
            return __( 'Adresse', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $adresse = get_option( 'contact_adresse' );
            return $adresse;
        }
    }

    $dynamic_tags->register_tag( 'Elementor_Adress_Tag' );
} );

/**
* Balise dynamique contenant le code postal.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui affiche le code postal.
* La valeur de la balise est récupérée à partir de l'option 'contact_codepostal' et s'actualise
* automatiquement à chaque changement de cette option.
* La balise est disponible dans l'interface Elementor, dans la catégorie Texte, pour être utilisée
* dans les widgets et les modèles.
*/

add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_CodePostal_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'codePostal';
        }

        public function get_title() {
            return __( 'Code postal', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $codePostal = get_option( 'contact_codepostal' );
            return $codePostal;
        }
    }

    $dynamic_tags->register_tag( 'Elementor_codePostal_Tag' );
} );

/**
* Balise dynamique contenant la localité.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui affiche la localité.
* La valeur de la balise est récupérée à partir de l'option 'contact_localite' et s'actualise
* automatiquement à chaque changement de cette option.
* La balise est disponible dans l'interface Elementor, dans la catégorie Texte, pour être utilisée
* dans les widgets et les modèles.
*/
add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_localite_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'localite';
        }

        public function get_title() {
            return __( 'Ville', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $localite = get_option( 'contact_localite' );
            return $localite;
        }
    }

    $dynamic_tags->register_tag( 'Elementor_localite_Tag' );
} );

/**
 * Balise dynamique contenant la région.
 *
 * Ce code enregistre une balise dynamique personnalisée pour Elementor qui affiche la région.
 * La valeur de la balise est récupérée à partir de l'option 'contact_region' et s'actualise
 * automatiquement à chaque changement de cette option.
 * La balise est disponible dans l'interface Elementor, dans la catégorie Texte, pour être utilisée
 * dans les widgets et les modèles.
 */
add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_region_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'region';
        }

        public function get_title() {
            return __( 'Région', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $region = get_option( 'contact_region' );
            return $region;
        }
    }

    $dynamic_tags->register_tag( 'Elementor_region_Tag' );
} );



/**
* Ajoute une balise dynamique dans la catégorie URL qui récupère le lien Facebook.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui permet de récupérer
* le lien Facebook à partir de l'option 'contact_facebook_url' et de l'afficher dans une balise URL.
* La balise est ajoutée à la catégorie URL dans l'interface Elementor, ce qui permet de l'utiliser
* dans les widgets et les modèles pour créer des liens vers la page Facebook.
*/

  add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_facebook_url_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
        return 'facebookUrl';
    }

    public function get_title() {
        return __( 'Facebook URL', 'text-domain' );
    }

    public function get_group() {
        return 'base';
    }

    public function get_categories() {
        return [ \Elementor\Modules\DynamicTags\Module::URL_CATEGORY ];
    }

    public function get_value( array $options = [] ) {
        $facebook = get_option( 'contact_facebook_url' );
        return $facebook;
    }

}

$dynamic_tags->register_tag( 'Elementor_facebook_url_Tag' );
} );


/*
* Ajoute une balise dynamique dans la catégorie URL qui récupère le lien Instagram.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui permet de récupérer
* le lien Instagram à partir de l'option 'contact_instagram_url' et de l'afficher dans une balise URL.
* La balise est ajoutée à la catégorie URL dans l'interface Elementor, ce qui permet de l'utiliser
* dans les widgets et les modèles pour créer des liens vers la page Instagram.
*/
add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_instagram_url_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'instagramUrl';
        }

        public function get_title() {
            return __( 'Instagram URL', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::URL_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $instagram = get_option( 'contact_instagram_url' );
            return $instagram;
        }
    }

    $dynamic_tags->register_tag( 'Elementor_instagram_url_Tag' );
} );


/*
* Ajoute une balise dynamique dans la catégorie URL qui récupère le lien Twitter.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui permet de récupérer
* le lien Twitter à partir de l'option 'contact_twitter_url' et de l'afficher dans une balise URL.
* La balise est ajoutée à la catégorie URL dans l'interface Elementor, ce qui permet de l'utiliser
* dans les widgets et les modèles pour créer des liens vers la page Twitter.
*/
add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_twitter_url_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'twitterUrl';
        }

        public function get_title() {
            return __( 'Twitter URL', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::URL_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $twitter = get_option( 'contact_twitter_url' );
            return $twitter;
        }
    }
    $dynamic_tags->register_tag( 'Elementor_twitter_url_Tag' );
} );


/*
* Ajoute une balise dynamique dans la catégorie URL qui récupère le lien YouTube.
*
* Ce code enregistre une balise dynamique personnalisée pour Elementor qui permet de récupérer
* le lien YouTube à partir de l'option 'contact_youtube_url' et de l'afficher dans une balise URL.
* La balise est ajoutée à la catégorie URL dans l'interface Elementor, ce qui permet de l'utiliser
* dans les widgets et les modèles pour créer des liens vers la page YouTube.
*/
add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_youtube_url_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'youtubeUrl';
        }

        public function get_title() {
            return __( 'YouTube URL', 'text-domain' );
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::URL_CATEGORY ];
        }

        public function get_value( array $options = [] ) {
            $youtube = get_option( 'contact_youtube_url' );
            return $youtube;
        }
    }

    $dynamic_tags->register_tag( 'Elementor_youtube_url_Tag' );
} );

/**
* Ajoute une balise dynamique dans la catégorie TEXT qui récupère l'adresse complète 
*/
add_action('elementor/dynamic_tags/register_tags', function($dynamic_tags) {
    class Elementor_Adresse_Complete_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'addresseComplète';
        }

        public function get_title() {
            return __('Adresse complète', 'text-domain');
        }

        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = []) {
            $adresse = get_option('contact_adresse');
            $ville = get_option('contact_localite');
            $codePostal = get_option('contact_codePostal');
            $region = get_option('contact_region');

            $adresseComplete = "{$adresse}<br>{$codePostal} {$ville}";

            return $adresseComplete;
        }
    }

    $dynamic_tags->register_tag('Elementor_Adresse_Complete_Tag');
} );

/*
    Ajoute une balise dynamique qui récupère les mots clés et permet de les afficher
*/

add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    
    // définition d'une classe personnalisée pour la balise dynamique 'description generale'
    class Elementor_keyword_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
            return 'keywords';
        }

        public function get_title() {
            return __( 'Mots clés', 'text-domain' );
        }
        
       /* méthode qui retourne le groupe de la balise dynamique, ici 'base'
        *  cela permet de classer la balise dans un groupe spécifique de l'interface Elementor 
        */
        public function get_group() {
            return 'base';
        }

        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        public function get_value( array $options = [] ) {

            // récupération de les mots clé à partir de l'option 'seo_keyword' du formulaire 'informations'
            $keywords = get_option( 'seo_keyword' );
            return $keywords;
        }
    }

    // enregistrement de la balise dynamique 'keywords' 
    $dynamic_tags->register_tag( 'Elementor_keyword_Tag' );
} );


/*
Balise dynamique pour recuperer l'url GoogleMaps du formulaire d'informations
*/

add_action( 'elementor/dynamic_tags/register_tags', function( $dynamic_tags ) {
    class Elementor_maps_url_Tag extends \Elementor\Core\DynamicTags\Data_Tag {
        public function get_name() {
        return 'mapsUrl';
    }

    public function get_title() {
        return __( 'Google Maps URL', 'text-domain' );
    }

    public function get_group() {
        return 'base';
    }


    public function get_categories() {
        return [ \Elementor\Modules\DynamicTags\Module::URL_CATEGORY ];
        // return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
    }

    public function get_value( array $options = [] ) {
        $maps = get_option( 'url_gmap' );
        return $maps;
    }

}

$dynamic_tags->register_tag( 'Elementor_maps_url_Tag' );
} );




/********************************************************************************************************************************/

/**
* Ajoute une nouvelle catégorie personnalisée à Elementor.
*
* Ce code crée une nouvelle catégorie appelée 'emandarineWidgets' dans l'interface Elementor.
* La catégorie est associée au titre 'emandarine widgets' et à l'icône 'fa fa-plug' (un téléphone).
* Cette catégorie permet d'organiser et de regrouper des widgets personnalisés spécifiques au thème 'emandarine_widgets'.
*/

 function emandarine_widgets_elementor_category() {
    \Elementor\Plugin::$instance->elements_manager->add_category(
        'emandarineWidgets',
        [
            'title' => __( 'Widgets emandarine', 'emandarine_widgets' ),
            'icon' => 'fa fa-plug',
        ]
    );
}
add_action( 'elementor/init', 'emandarine_widgets_elementor_category' );

